
WorkFilePath='E:\DATA_SEEG\行为结果\Result\';
cd(WorkFilePath);
Sublist=dir([WorkFilePath,'*beh1*']);
outputpath='群体结果1';
mkdir(outputpath);
Msub=[];
for i=1:length(Sublist)
cd(Sublist(i).name)
temp=dir(['*_',Sublist(i).name(1:2),'*']);
load([temp.name,'\SubResult.mat']);
Fitresult = psyCurvePlot(SubResult);
Msub.x(i,:)=Fitresult.x;
Msub.y(i,:)=Fitresult.y;

cd ..
end

cd(outputpath)

Px1=Msub.x(:);
Py1=Msub.y(:);
[~,index]=sortrows(Px1,'ascend');
Px2=Px1(index);
Py2=Py1(index);


nbins=6;
nsession=size(Msub.x,1);
h=histogram(Px2(nsession+1:end-nsession),nbins);
binData=[];
for j=1:nbins       %不同bin
    temp=h.BinEdges;
    index1=find(Px2>=temp(j) & Px2<temp(j+1));
    contratemp=Px2(index1);
    aptemp=Py2(index1);
    binData.ap(1,j)=mean(aptemp);
    binData.ap(2,j)=std(aptemp)./sqrt(length(aptemp)-1);  %sem
    binData.contra(1,j)=mean(contratemp);
   
end
close
x= [mean(Px2(1:nsession)) binData.contra mean(Px2(end-nsession+1:end))];
y=[mean(Py2(1:nsession)) binData.ap(1,:) mean(Py2(end-nsession+1:end))];
ye=[std(Py2(1:nsession))./sqrt(nsession-1) binData.ap(2,:) std(Py2(end-nsession+1:end))./sqrt(nsession-1)];

x= mean(Msub.x);
y=mean(Msub.y);
ye=std(Msub.y)./sqrt(nsession-1);





[fitresult, gof]=createFits_bin(x, y);
hold on
errorbar(x,y,ye,...
    'CapSize',0,'LineWidth',1.5,'LineStyle','none','Color',[0 0 0]);
hold off
ax=gca;
ax.FontSize=18;
ax.LineWidth=1.5;
xlim([min(x),max(x)])
title(strcat('N=',num2str(size(Msub.y,1))))
R2=gof.rsquare;
% text(5,10,strcat('R^2=',sprintf('%.2f',R2)),'FontSize',18);
saveas(gcf,strcat('Pop_psyCurve'),'tif')
saveas(gcf,strcat('Pop_psyCurve'),'fig')
Fitresult.fitresult=fitresult;
Fitresult.gof=gof;
Fitresult.x=x;
Fitresult.y=y;
save Fitresult Fitresult Msub
ax=gca;
ax.FontSize=18;
ax.LineWidth=1.5;
xlabel('Stimulus Contrast Aligned to Threshold (%)')


%% Curve线画在一起
figure
hold on
for i=1:size(Msub.x,1)
  x=Msub.x(i,:);
  y=Msub.y(i,:);
[xData, yData] = prepareCurveData( x, y );

% Set up fittype and options.
ft = fittype( 'a+b./(1+exp(-d*(x-c)))', 'independent', 'x', 'dependent', 'y' );
opts = fitoptions( 'Method', 'NonlinearLeastSquares' );
opts.Display = 'Off';
b=max(y);
c=median(x);
d=1;
a=min(y);
opts.StartPoint = [a b c d];

% Fit model to data.
[fitresult, gof] = fit( xData, yData, ft, opts );

% Plot fit with data.
% figure( 'Name', 'Psychmetric Curve' );



if i<=10
    plot(xData, yData,'.k','MarkerSize',20);
h=plot( fitresult,'k');
else
    plot(xData, yData,'.r','MarkerSize',20);
h=plot( fitresult,'r');    
end
h.LineWidth=2;
legend( {'Data','Fitted Curve'}, 'Location', 'northwest', 'Interpreter', 'none','AutoUpdate','off');
% Label axes
xlabel( 'Stimulus Contrast (%)', 'Interpreter', 'none' );
ylabel( 'Aware Percent (%)', 'Interpreter', 'none' );
ylim([0 105])
R2=gof.rsquare;
text(6,15,strcat('R^2=',sprintf('%.2f',R2),'FontSize',10));
% xlabel( 'Stimulus Contrast Relative to Threshold (%)', 'Interpreter', 'none' );
box off
slope(1,i)=fitresult.d;
totalR2(1,i)=gof.rsquare;

end
hold off

yline([75 25],'--','LineWidth',1.5)
text()